# Stored Procedure: Centros costo

DELIMITER //
CREATE PROCEDURE SP_CentrosCosto (
    IN numCuenta_Param VARCHAR(100),
    IN nombreCentroCosto_Param VARCHAR(100),
    IN idEmpresa_Param INT
)
BEGIN
    IF EXISTS (SELECT * FROM centrosCosto WHERE cuenta = numCuenta_Param AND idEmpresas = idEmpresa_Param LIMIT 1)
    THEN
        UPDATE centrosCosto
        SET
            cuenta = numCuenta_Param, 
            descripcion = nombreCentroCosto_Param,
            idTipoOperacionContable = 2,
            idEmpresas = idEmpresa_Param,
            updated_at = CURRENT_TIMESTAMP()
        WHERE
            cuenta = numCuenta_Param AND idEmpresas = idEmpresa_Param;
    ELSE
        INSERT INTO centrosCosto(
            cuenta,
            descripcion,
            idTipoOperacionContable,
            idEmpresas,
            created_at
        )
        VALUES(
            numCuenta_Param,
            nombreCentroCosto_Param,
            2,
            idEmpresa_Param,
            CURRENT_TIMESTAMP()
        );           
    END IF;
END //
DELIMITER ;