SELECT * FROM erp_bbs.clientes;
describe clientes;

# Stored Procedure: Clientes

DELIMITER //
CREATE PROCEDURE SP_Clientes(
    IN codigoCliente_Param VARCHAR(100),
    IN nombreCliente_Param VARCHAR(100),
    IN nombreFacturacion_Param VARCHAR(100),
    IN nombreContacto_Param VARCHAR(100),
    IN NIT_Param VARCHAR(100),
    IN paises_Param VARCHAR(100),
    IN departamento_Param VARCHAR(100),
    IN municipio_Param VARCHAR(100),
    IN zona_Param VARCHAR(100),
    IN dirCliente_Param VARCHAR(100),
    IN telContacto_Param VARCHAR(100),
    IN email_Param VARCHAR(100),
    IN limCredito_Param VARCHAR(100),
    IN diasCredito_Param VARCHAR(100),
    IN tipoClientes_Param VARCHAR(100),
    IN habilitaCredito_Param VARCHAR(100),
    IN cuentaContPagar_Param VARCHAR(100),
    IN cuentaContCobrar_Param VARCHAR(100),
    IN agenteRetenedor_Param VARCHAR(100),
    IN retencion_Param VARCHAR(100),
    IN idEmpresas_Param INT
)
BEGIN
	DECLARE paises_ INT;
    DECLARE departamentos_ INT;
    DECLARE municipios_ INT;
	
	IF EXISTS (SELECT * FROM paises WHERE descripcion = paises_Param AND idEmpresas = idEmpresas_Param LIMIT 1)
    THEN 
		SET paises_ = (SELECT id FROM paises WHERE descripcion = paises_Param AND idEmpresas = idEmpresas_Param );
	ELSE
		SET paises_ = 0;
    END IF;
    
	IF EXISTS (SELECT * FROM departamentos WHERE descripcion = departamento_Param AND idEmpresas = idEmpresas_Param LIMIT 1)
    THEN
		SET departamentos_ = (SELECT id FROM departamentos WHERE descripcion = departamento_Param AND idEmpresas = idEmpresas_Param);
    ELSE
		SET departamentos_ = 0;
    END IF;
    
    IF EXISTS (SELECT * FROM municipios WHERE descripcion = municipio_Param AND idEmpresas = idEmpresas_Param AND idDepartamentos = departamentos_ LIMIT 1)
    THEN
		SET municipios_ =  (SELECT id FROM municipios WHERE descripcion = municipio_Param AND idEmpresas = idEmpresas_Param AND idDepartamentos = departamentos_);
    ELSE 
		SET municipios_ = 0;
    END IF;

    IF EXISTS (SELECT * FROM clientes WHERE codigoC = codigoCliente_Param AND idEmpresas = idEmpresas_Param LIMIT 1)
    THEN
        UPDATE clientes SET 
            codigoC =  codigoCliente_Param,
            nombreC = nombreCliente_Param,
            nombreF = nombreFacturacion_Param,
            contacto = nombreContacto_Param || '',
            docIdentificacion = '',
            nitC = NIT_Param,
            idPaises = paises_,
            idDepartamentos = departamentos_,
            idMunicipios = municipios_,
            zona = zona_Param || '',
            direccionC = dirCliente_Param,
            telefonoC = telContacto_Param,
            mail = email_Param,
            limiteCredito = limCredito_Param,
            diasCredito = diasCredito_Param,
            idTipoClientes = (SELECT id FROM tipoClientes WHERE descripcion = tipoClientes_Param),
            idAvailableCreditLimit = (SELECT id FROM availableCreditLimit WHERE descripcion = habilitaCredito_Param),
            idNomenclatura = 0,
            idCentrosCosto = 1,
            idUsuarios = 159, 
            idClasificacionClientes = 0,
            idEmpresas = idEmpresas_Param,
            updated_at = CURRENT_TIMESTAMP(),
            idAgenteRetenedor = (SELECT id FROM agenteRetenedor WHERE descripcion = agenteRetenedor_Param),
            porcRetension = retencion_Param
        WHERE codigoC = codigoCliente_Param AND idEmpresas = idEmpresas_Param;
    ELSE
		INSERT INTO clientes (
			codigoC,
            nombreC,
            nombreF,
            contacto,
            docIdentificacion,
            nitC,
            idPaises,
            idDepartamentos,
            idMunicipios,
            zona,
            direccionC,
            telefonoC,
            mail,
            limiteCredito,
            diasCredito,
            idTipoClientes,
            idAvailableCreditLimit,
            idNomenclatura,
            idCentrosCosto,
            idUsuarios,
            idClasificacionClientes,
            idEmpresas,
            created_at,
            idAgenteRetenedor,
            porcRetension
        )
        VALUES(
			codigoCliente_Param,
            nombreCliente_Param,
            nombreFacturacion_Param,
            nombreContacto_Param || '',
            '',
            NIT_Param,
            paises_,
            departamentos_,
            municipios_,
            zona_Param || '',
            dirCliente_Param,
            telContacto_Param,
            email_Param,
            limCredito_Param,
            diasCredito_Param,
            (SELECT id FROM tipoClientes WHERE descripcion = tipoClientes_Param),
            (SELECT id FROM availableCreditLimit WHERE descripcion = habilitaCredito_Param),
            0,
            1,
            159, 
            0,
            idEmpresas_Param,
            CURRENT_TIMESTAMP(),
            (SELECT id FROM agenteRetenedor WHERE descripcion = agenteRetenedor_Param),
            retencion_Param
        );
    END IF;
END //
DELIMITER ;