# Stored Procedure: Nomenclatura
DELIMITER //
CREATE PROCEDURE SP_Nomenclatura(
    IN numCuenta_Param VARCHAR(100),
    IN nivelDetalle_Param VARCHAR(100),
    IN nombreCuenta_Param VARCHAR(100),
    IN numCuentaPadre_Param VARCHAR(100),
    IN tipoCuenta_Param VARCHAR(100),
    IN tipoOperacion_Param VARCHAR(100),
    IN idEmpresa_Param INT
)
BEGIN
    IF EXISTS (SELECT * FROM nomenclatura WHERE cuenta = numCuenta_Param AND idEmpresas = idEmpresa_Param)
    THEN
        UPDATE nomenclatura
        SET
            cuenta = numCuenta_Param,
            nivel = nivelDetalle_Param,
            descripcion = nombreCuenta_Param,
            padre = numCuentaPadre_Param,
            idTipoCuentaContable = (SELECT id FROM tipoCuentaContable WHERE UPPER(descripcion) = UPPER(tipoCuenta_Param)),
            idTipoOperacionContable = (SELECT id FROM tipoOperacionContable WHERE UPPER(descripcion) = UPPER(tipoOperacion_Param)),
            idEmpresas = idEmpresa_Param,
            updated_at = CURRENT_TIMESTAMP()
        WHERE 
            cuenta = numCuenta_Param AND idEmpresas = idEmpresa_Param;
    ELSE
        INSERT INTO nomenclatura (
            cuenta,
            nivel,
            descripcion,
            padre,
            idTipoCuentaContable,
            idTipoOperacionContable,
            idEmpresas,
            created_at
        )
        VALUES (
            numCuenta_Param,
            nivelDetalle_Param,
            nombreCuenta_Param,
            numCuentaPadre_Param,
            (SELECT id FROM tipoCuentaContable WHERE UPPER(descripcion) = UPPER(tipoCuenta_Param)),
            (SELECT id FROM tipoOperacionContable WHERE UPPER(descripcion) = UPPER(tipoOperacion_Param)),
            idEmpresa_Param,
            CURRENT_TIMESTAMP()
        );
    END IF;

END //
DELIMITER ;