# Stored Procedure: Productos
DELIMITER //
CREATE PROCEDURE SP_Productos (
	IN sku_Param varchar(100),
	IN upc_Param varchar(100),
	IN descripcion_Param varchar(100),
	IN costo_Param double(7,2),
	IN margen_Param double(20,2),
	IN precio_Param double(7,2),
	IN tipoProductos_Param varchar(100),
	IN fabricaProducto_Param varchar(100),
	IN utilzaSerie_Param varchar(100),
	IN medidas_Param varchar(100),
	IN equivalente_Param double(7,0),
	IN medidas2_Param varchar(100),
	IN marcas_Param varchar(100),
	IN departamento_Param varchar(100),
	IN categoria_Param varchar(100),
	IN subCategoria_Param varchar(100),
	IN statusProducto_Param varchar(100),
	IN disponibleVenta_Param varchar(100),
    IN idEmpresa_Param INT
)
BEGIN

DECLARE medidas INT;
DECLARE medidas2 INT;
DECLARE marcas INT;
DECLARE departamento INT;
DECLARE categoria INT;
DECLARE subCategoria INT;

# Medidas
IF 
	EXISTS(SELECT * FROM medidas WHERE UPPER(descripcion)=UPPER(medidas_Param) AND idEmpresas=idEmpresa_Param LIMIT 1)	
THEN 
	SET medidas = (SELECT id FROM medidas WHERE UPPER(descripcion)=UPPER(medidas_Param) AND idEmpresas=idEmpresa_Param LIMIT 1);
ELSE	
	INSERT INTO medidas (descripcion, abrev, idEmpresas, created_at) VALUES (medidas_Param, medidas_Param, idEmpresa_Param, CURRENT_TIMESTAMP());    
	SET medidas = (SELECT id FROM medidas WHERE UPPER(descripcion)=UPPER(medidas_Param) AND idEmpresas=idEmpresa_Param LIMIT 1);
END IF;

# Medidas 2
IF 
	EXISTS(SELECT * FROM medidas WHERE UPPER(descripcion)=UPPER(medidas2_Param) AND idEmpresas=idEmpresa_Param LIMIT 1)	
THEN 
	set medidas2 = (SELECT id FROM medidas WHERE UPPER(descripcion)=UPPER(medidas2_Param) AND idEmpresas=idEmpresa_Param LIMIT 1);
ELSE	
	INSERT INTO medidas (descripcion, abrev, idEmpresas, created_at) VALUES (medidas2_Param, medidas2_Param, idEmpresa_Param, CURRENT_TIMESTAMP());    
    set medidas2 = (SELECT id FROM medidas WHERE descripcion=idMedidas2_Param AND idEmpresas=idEmpresa_Param LIMIT 1);
END IF;

# Marcas
IF 
	EXISTS(SELECT * FROM marcas WHERE UPPER(descripcion)=UPPER(marcas_Param) AND idEmpresas=idEmpresa_Param LIMIT 1)	
THEN 
	set marcas = (SELECT id FROM marcas WHERE UPPER(descripcion)=UPPER(marcas_Param) AND idEmpresas=idEmpresa_Param LIMIT 1);
ELSE	
	INSERT INTO marcas (descripcion, descCorta, idEmpresas, created_at) VALUES (marcas_Param, marcas_Param, idEmpresa_Param, CURRENT_TIMESTAMP());    
    set marcas = (SELECT id FROM marcas WHERE UPPER(descripcion)=UPPER(marcas_Param) AND idEmpresas=idEmpresa_Param LIMIT 1);
END IF;

# Familia Nivel 1 = Departamentos
IF 
	EXISTS(SELECT * FROM familiaNivel1 WHERE UPPER(descripcion)=UPPER(departamento_Param) AND idEmpresas=idEmpresa_Param LIMIT 1)	
THEN 
	set departamento = (SELECT id FROM familiaNivel1 WHERE UPPER(descripcion)=UPPER(departamento_Param) AND idEmpresas=idEmpresa_Param LIMIT 1);
ELSE	
	INSERT INTO familiaNivel1 (descripcion, idNomenclatura, idCentrosCosto, idEmpresas, created_at) 
    VALUES (departamento_Param, 0, 0, idEmpresa_Param, CURRENT_TIMESTAMP());
	set departamento = (SELECT id FROM familiaNivel1 WHERE UPPER(descripcion)=UPPER(departamento_Param) AND idEmpresas=idEmpresa_Param LIMIT 1);
END IF;

# Familia Nivel 2 = Categoría
IF 
	EXISTS(SELECT * FROM familiaNivel2 WHERE UPPER(descripcion)=UPPER(categoria_Param) AND idEmpresas=idEmpresa_Param LIMIT 1)	
THEN 
	set categoria = (SELECT id FROM familiaNivel2 WHERE UPPER(descripcion)=UPPER(categoria_Param) AND idEmpresas=idEmpresa_Param LIMIT 1);
ELSE	
	INSERT INTO familiaNivel2 (descripcion, idFamiliaNivel1, idNomenclatura, idCentrosCosto, idEmpresas, created_at) 
    VALUES (categoria_Param, departamento, 0, 0, idEmpresa_Param, CURRENT_TIMESTAMP());
	set categoria = (SELECT id FROM familiaNivel2 WHERE UPPER(descripcion)=UPPER(categoria_Param) AND idEmpresas=idEmpresa_Param LIMIT 1);
END IF;

# Familia Nivel 3 = Sub Categoría
IF 
	EXISTS(SELECT * FROM familiaNivel3 WHERE UPPER(descripcion)=UPPER(subCategoria_Param) AND idEmpresas=idEmpresa_Param LIMIT 1)	
THEN 
	set subCategoria = (SELECT id FROM familiaNivel3 WHERE UPPER(descripcion)=UPPER(subCategoria_Param) AND idEmpresas=idEmpresa_Param LIMIT 1);
ELSE	
	INSERT INTO familiaNivel3 (descripcion, idFamiliaNivel2, idNomenclatura, idCentrosCosto, idEmpresas, created_at) 
    VALUES (subCategoria_Param, categoria, 0, 0, idEmpresa_Param, CURRENT_TIMESTAMP());
	set subCategoria = (SELECT id FROM familiaNivel3 WHERE UPPER(descripcion)=UPPER(subCategoria_Param) AND idEmpresas=idEmpresa_Param LIMIT 1);
END IF;

IF 
	EXISTS(SELECT * FROM productos WHERE sku=sku_Param AND idEmpresas=idEmpresa_Param LIMIT 1)	
THEN 
	UPDATE productos SET 
    sku = sku_Param,
	upc = upc_Param,	
    descLarga = descripcion_Param,
    precioCosto = costo_Param,
	margen = margen_Param,
	precioPublico = precio_Param,
	idTipoProductos = (SELECT id FROM tipoProductos WHERE UPPER(descripcion) = UPPER(tipoProductos_Param) LIMIT 1),
    idFabricaProducto = (CASE WHEN idTipoProductos = 3 THEN idFabricaProducto = 1 ELSE idFabricaProducto = 2 END),
    idUtilizaSerie = (SELECT id FROM utilizaSerie WHERE UPPER(descripcion) = UPPER(utilzaSerie_Param) LIMIT 1),
    idMedidas = medidas,
    equivalente = equivalente_Param,
	idMedidas2 =  medidas2,
	idMarcas = marcas,
	idFamiliaNivel1 = departamento,
	idFamiliaNivel2 = categoria,
	idFamiliaNivel3 = subCategoria,
	idAvailableSale = (SELECT id FROM availableSale WHERE UPPER(descripcion) = UPPER(disponibleVenta_Param) LIMIT 1),
	idStatusProducto = 1,
	updated_at = CURRENT_TIMESTAMP()
	WHERE sku=sku_Param AND idEmpresas=idEmpresa_Param;
ELSE	
	INSERT INTO 
		productos (
			sku, 
			upc, 
			descLarga, 
			precioCosto, 
			margen, 
			precioPublico, 
			idTipoProductos, 
			idFabricaProducto, 
			idUtilizaSerie, 
			idMedidas, 
			equivalente, 
			idMedidas2,
			idMarcas, 
			idFamiliaNivel1, 
			idFamiliaNivel2, 
			idFamiliaNivel3, 
			idEmpresas, 
			idAvailableSale, 
			idStatusProducto, 
			created_at
		)
	VALUES (
		sku_Param, 
		upc_Param, 
		descripcion_Param, 
		costo_Param, 
		margen_Param, 
		precio_Param,
		(SELECT id FROM tipoProductos WHERE UPPER(descripcion) = UPPER(tipoProductos_Param) LIMIT 1),
		(CASE WHEN idTipoProductos = 3 THEN idFabricaProducto = 1 ELSE idFabricaProducto = 2 END),
		(SELECT id FROM utilizaSerie WHERE UPPER(descripcion) = UPPER(utilzaSerie_Param) LIMIT 1),
		medidas,
		equivalente_Param,
        medidas2,
		marcas,
		departamento,
		categoria,
		subCategoria,
		idEmpresa_Param,
		(SELECT id FROM availableSale WHERE UPPER(descripcion) = UPPER(disponibleVenta_Param) LIMIT 1),
		1,
		CURRENT_TIMESTAMP()
	);   
    INSERT INTO inventarios(
		idTipoInventario,
		ingresoA,
		idPuntoIngreso,
		documento,
		idTipoProductos,
		idProductos,
		ingreso,
		salida,
		saldo,
		idUsuarios,
		idEmpresas,
		created_at
	)
	VALUES(
		1,
		2,
		1,
		'INGRESO DE PRODUCTOS POR EXCEL',
		(SELECT id FROM tipoProductos WHERE UPPER(descripcion) = UPPER(tipoProductos_Param) LIMIT 1),
		(SELECT id FROM productos WHERE sku = sku_Param LIMIT 1),
		1,
		0,
		1,
		0,
		idEmpresa_Param,
		CURRENT_TIMESTAMP()
	);
END IF;
END //
DELIMITER ;



DELIMITER //
CREATE PROCEDURE SP_Inventarios()
BEGIN
	INSERT INTO inventarios(
		idTipoInventario,
		ingresoA,
		idPuntoIngreso,
		documento,
		idTipoProductos,
		idProductos,
		ingreso,
		salida,
		saldo,
		idUsuarios,
		idEmpresas,
		created_at
	)
	VALUES(
		1,
		2,
		1,
		'INGRESO DE PRODUCTOS POR EXCEL',
		(SELECT id FROM tipoProductos WHERE UPPER(descripcion) = UPPER(tipoProductos_Param) LIMIT 1),
		(SELECT id FROM productos WHERE sku = sku_Param LIMIT 1),
		1,
		0,
		1,
		0,
		idEmpresa_Param,
		CURRENT_TIMESTAMP()
	);
END //
DELIMITER ;
